using System;
using System.Data;
using System.Data.SqlTypes;
using System.Data.SqlClient;
using MethodBase = System.Reflection.MethodBase;
using gov.va.med.vbecs.ExceptionManagement;
using STOREDPROC = gov.va.med.vbecs.Common.VbecsStoredProcs;
using gov.va.med.vbecs.Common;

namespace gov.va.med.vbecs.DAL
{
	#region Header

	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>Cameron Taylor</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>04/16/2004</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///<summary>
	/// TestingWorklist data access layer class.
	///</summary>

	#endregion
	
	public class TestingWorklist
	{

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/26/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1241"> 
		///		<ExpectedInput>Valid start and end dates in the past, true for all booleans</ExpectedInput>
		///		<ExpectedOutput>Integer</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1244"> 
		///		<ExpectedInput>false for all booleans</ExpectedInput>
		///		<ExpectedOutput>0</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// GetTestingWorklistCount
		/// </summary>
		/// <param name="startDate"></param>
		/// <param name="endDate"></param>
		/// <param name="includePatientTesting"></param>
		/// <param name="includeUnitTesting"></param>
		/// <param name="includeRackQCTesting"></param>
		/// <param name="includeReagentQCTesting"></param>
		/// <returns></returns>
		public static int GetTestingWorklistCount(DateTime startDate, DateTime endDate, bool includePatientTesting, bool includeUnitTesting, bool includeRackQCTesting, bool includeReagentQCTesting)
		{
			int count = 0;
			//
			if (includePatientTesting)
			{
				SqlParameter [] prms = 
				{
					new SqlParameter(STOREDPROC.GetPatientTestingWorklistCount.StartDate, System.Data.SqlDbType.DateTime),
					new SqlParameter(STOREDPROC.GetPatientTestingWorklistCount.EndDate, System.Data.SqlDbType.DateTime),
					new SqlParameter(STOREDPROC.GetPatientTestingWorklistCount.DivisionCode, System.Data.SqlDbType.Char)
				};
				prms[0].Value = startDate;
				prms[1].Value = endDate;
				prms[2].Value = Common.LogonUser.LogonUserDivisionCode;
				//
				DataTable dt = StoredProcedure.GetData(STOREDPROC.GetPatientTestingWorklistCount.StoredProcName, prms).Tables[0];
				foreach(DataRow dr in dt.Rows)
				{
					count += (int)dr["Total"];
				}
			}
			//
			if (includeUnitTesting)
			{
				SqlParameter [] prms = 
				{
					new SqlParameter(STOREDPROC.GetBloodUnitTestingWorklistCount.startdate, System.Data.SqlDbType.DateTime),
					new SqlParameter(STOREDPROC.GetBloodUnitTestingWorklistCount.enddate, System.Data.SqlDbType.DateTime),
					new SqlParameter(STOREDPROC.GetBloodUnitTestingWorklistCount.divisioncode, System.Data.SqlDbType.Char)
				};
				prms[0].Value = startDate;
				prms[1].Value = endDate;
				prms[2].Value = Common.LogonUser.LogonUserDivisionCode;
				//
				count += (int)(StoredProcedure.GetData(STOREDPROC.GetBloodUnitTestingWorklistCount.StoredProcName, prms).Tables[0].Rows[0]["Total"]);
			}
			//
			if (includeRackQCTesting)
			{
				SqlParameter [] prms = 
				{
					new SqlParameter(STOREDPROC.GetRackQCTestingWorklistCount.StartDate, System.Data.SqlDbType.DateTime),
					new SqlParameter(STOREDPROC.GetRackQCTestingWorklistCount.EndDate, System.Data.SqlDbType.DateTime),
					new SqlParameter(STOREDPROC.GetRackQCTestingWorklistCount.DivisionCode, System.Data.SqlDbType.Char)
				};
				prms[0].Value = startDate;
				prms[1].Value = endDate;
				prms[2].Value = Common.LogonUser.LogonUserDivisionCode;
				//
				count += (int)(StoredProcedure.GetData(STOREDPROC.GetRackQCTestingWorklistCount.StoredProcName, prms).Tables[0].Rows[0]["Total"]);
			}
			//
			if (includeReagentQCTesting)
			{
				SqlParameter [] prms = 
				{
					new SqlParameter(STOREDPROC.GetReagentQCTestingWorklistCount.StartDate, System.Data.SqlDbType.DateTime),
					new SqlParameter(STOREDPROC.GetReagentQCTestingWorklistCount.EndDate, System.Data.SqlDbType.DateTime),
					new SqlParameter(STOREDPROC.GetReagentQCTestingWorklistCount.DivisionCode, System.Data.SqlDbType.Char)
				};
				prms[0].Value = startDate;
				prms[1].Value = endDate;
				prms[2].Value = Common.LogonUser.LogonUserDivisionCode;
				//
				count += (int)(StoredProcedure.GetData(STOREDPROC.GetReagentQCTestingWorklistCount.StoredProcName, prms).Tables[0].Rows[0]["Total"]);
			}
			//
			return count;
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>2/26/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3788"> 
		///		<ExpectedInput>Valid start and end dates in the past</ExpectedInput>
		///		<ExpectedOutput>Ordered test results data table</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="3789"> 
		///		<ExpectedInput>Invalid DateRange</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Static function to retrieve details of all patient specimen testing that occurred
		/// between the supplied date range.
		/// </summary>
		/// <param name="startDate">Start Date</param>
		/// <param name="endDate">End Date</param>
		/// <returns>Data table of specimen test information</returns>
		public static DataTable GetPatientTestingWorklist(DateTime startDate, DateTime endDate)
		{
			SqlParameter [] prms = 
			{
				new SqlParameter(STOREDPROC.GetPatientTestingWorklistByDates.StartDate, System.Data.SqlDbType.DateTime),
				new SqlParameter(STOREDPROC.GetPatientTestingWorklistByDates.EndDate, System.Data.SqlDbType.DateTime),
				new SqlParameter(STOREDPROC.GetPatientTestingWorklistByDates.DivisionCode, System.Data.SqlDbType.Char)
			};
			prms[0].Value = startDate;
			prms[1].Value = endDate;
			prms[2].Value = Common.LogonUser.LogonUserDivisionCode;

			DataTable dt = Common.StoredProcedure.GetData(STOREDPROC.GetPatientTestingWorklistByDates.StoredProcName, prms).Tables[0];
			dt.TableName = "PatientTestingWorklist";
			return dt;
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>2/26/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3786"> 
		///		<ExpectedInput>Valid patient unique identifier</ExpectedInput>
		///		<ExpectedOutput>Specimen test results data table</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="3787"> 
		///		<ExpectedInput>Empty PatientGuid</ExpectedInput>
		///		<ExpectedOutput>Argument exception thrown</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Static function to retrieve details of all patient specimen testing that occurred
		/// for a given patient
		/// </summary>
		/// <param name="patientGuid">Patient unique identifier</param>
		/// <returns>Data table of specimen test information</returns>
		public static DataTable GetPatientTestingWorklist(Guid patientGuid)
		{
			if (patientGuid == Guid.Empty)
			{
				throw new ArgumentException(Common.StrRes.SysErrMsg.Common.InvalidFormat("patient unique identifier").ResString);
			}
			//
			SqlParameter [] prms = 
			{
				new SqlParameter(STOREDPROC.GetPatientTestingWorklist.PatientGuid, System.Data.SqlDbType.UniqueIdentifier),
				new SqlParameter(STOREDPROC.GetPatientTestingWorklist.DivisionCode, System.Data.SqlDbType.Char)
			};
			prms[0].Value = patientGuid;
			prms[1].Value = Common.LogonUser.LogonUserDivisionCode;

			DataTable dt = Common.StoredProcedure.GetData(STOREDPROC.GetPatientTestingWorklist.StoredProcName, prms).Tables[0];
			dt.TableName = "PatientTestingWorklist";
			return dt;
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>2/26/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3780"> 
		///		<ExpectedInput>Valid start and end dates in the past</ExpectedInput>
		///		<ExpectedOutput>Blood unit test data table</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="3781"> 
		///		<ExpectedInput>Invalid DateRange</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Static function returning details of all unit testing that occurred between
		/// the supplied date range
		/// </summary>
		/// <param name="startDate">Start date</param>
		/// <param name="endDate">End date</param>
		/// <returns>Data table of blood unit testing information</returns>
		public static DataTable GetBloodUnitTestingWorklist(DateTime startDate, DateTime endDate)
		{
			SqlParameter [] prms = 
			{
				new SqlParameter(STOREDPROC.GetBloodUnitTestingWorklist.StartDate, System.Data.SqlDbType.DateTime),
				new SqlParameter(STOREDPROC.GetBloodUnitTestingWorklist.EndDate, System.Data.SqlDbType.DateTime),
				new SqlParameter(STOREDPROC.GetBloodUnitTestingWorklist.DivisionCode, System.Data.SqlDbType.Char)
			};
			prms[0].Value = startDate;
			prms[1].Value = endDate;
			prms[2].Value = Common.LogonUser.LogonUserDivisionCode;

			DataTable dt = Common.StoredProcedure.GetData(STOREDPROC.GetBloodUnitTestingWorklist.StoredProcName, prms).Tables[0];
			dt.TableName = "UnitTestingWorklist";
			return dt;
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>2/26/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3782"> 
		///		<ExpectedInput>Valid start and end dates in the past</ExpectedInput>
		///		<ExpectedOutput>Rack test results data table</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="3783"> 
		///		<ExpectedInput>Invalid DateRange</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Static function to retrieve details of Daily Rack QC testing that occurred
		/// between the supplied date range.
		/// </summary>
		/// <param name="startDate">Start Date</param>
		/// <param name="endDate">End Date</param>
		/// <returns>Data table of rack test information</returns>
		public static DataTable GetRackQCTestingWorklist(DateTime startDate, DateTime endDate)
		{
			if (startDate>endDate)
			{
				DateTime switchDate = endDate;
				endDate = startDate;
				startDate = switchDate;
			}
			//
			SqlParameter [] prms = 
			{
				new SqlParameter(STOREDPROC.GetRackQCTestingWorklist.StartDate, System.Data.SqlDbType.DateTime),
				new SqlParameter(STOREDPROC.GetRackQCTestingWorklist.EndDate, System.Data.SqlDbType.DateTime),
				new SqlParameter(STOREDPROC.GetRackQCTestingWorklist.DivisionCode, System.Data.SqlDbType.Char)
			};
			prms[0].Value = startDate;
			prms[1].Value = endDate;
			prms[2].Value = Common.LogonUser.LogonUserDivisionCode;

			DataTable dt = Common.StoredProcedure.GetData(STOREDPROC.GetRackQCTestingWorklist.StoredProcName, prms).Tables[0];
			dt.TableName = "RackTestingWorklist";
			return dt;
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>2/26/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3784"> 
		///		<ExpectedInput>Valid start and end dates in the past</ExpectedInput>
		///		<ExpectedOutput>Rack test results data table</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="3785"> 
		///		<ExpectedInput>Invalid Date Range</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Static function to retrieve details of miscellaneous reagent QC testing that occurred
		/// between the supplied date range.
		/// </summary>
		/// <param name="startDate">Start Date</param>
		/// <param name="endDate">End Date</param>
		/// <returns>Data table of rack test information</returns>
		public static DataTable GetReagentQCTestingWorklist(DateTime startDate, DateTime endDate)
		{
			if (startDate>endDate)
			{
				DateTime switchDate = endDate;
				endDate = startDate;
				startDate = switchDate;
			}
			//
			SqlParameter [] prms = 
			{
				new SqlParameter(STOREDPROC.GetReagentQCTestingWorklist.StartDate, System.Data.SqlDbType.DateTime),
				new SqlParameter(STOREDPROC.GetReagentQCTestingWorklist.EndDate, System.Data.SqlDbType.DateTime),
				new SqlParameter(STOREDPROC.GetReagentQCTestingWorklist.DivisionCode, System.Data.SqlDbType.Char)
			};
			prms[0].Value = startDate;
			prms[1].Value = endDate;
			prms[2].Value = Common.LogonUser.LogonUserDivisionCode;

			DataTable dt = Common.StoredProcedure.GetData(STOREDPROC.GetReagentQCTestingWorklist.StoredProcName, prms).Tables[0];
			dt.TableName = "ReagentTestingWorklist";
			return dt;
		}
	}
}
